	function [G, Z, P] = X_2_PZ(X)

	% 	Converts X parameters to poles and zeros 
	%	X(1) = G
	% 	X(2...Nz) = a1n a2n ....
	% 	X(Nz+1...Nz+Np+1) = -b1n -b2n ....
	% 	Nz = number of zeros and Np number of poles
	% 	and
	%			 Prod(z^2 + a1n z + a2n)
	%	H(z) = G _____________________
	%             Prod(z2 -b1n z - b2n)

	% 	Toolbox for DIGITAL FILTERS USING MATLAB
 
	% 	Author: 		Lars Wanhammar 2010-10-12
	% 	Modified by: 	 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:			 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com

	global p Des wT Nz Np
 
	G = X(1);
	for n = 1:2:Nz-mod(Nz, 2)-1
		R = roots([1 X(n+1) X(n+2)]);
		Z(n) = R(1);
		Z(n+1) = R(2);
	end
	if mod(Nz, 2) == 1
		Z(Nz) = X(Nz+1);
	end
	for n = 1:2:Nz-mod(Np, 2)-1
		R = roots([1 -X(n+Nz+1) -X(n+Nz+2)]);
		P(n) = R(1);
		P(n+1) = R(2);
	end
	if mod(Np, 2) == 1
		P(Np+Nz+1) = -X(Np+Nz+1);
	end
	return
